/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.debug.ui;

import com.aptana.core.logging.IdeLog;
import com.aptana.core.resources.IUniformResource;
import com.aptana.core.resources.IUniformResourceMarker;
import com.aptana.core.resources.UniformResourceStorage;
import com.aptana.core.util.ArrayUtil;
import com.aptana.debug.ui.DebugUiPlugin;
import com.aptana.debug.ui.internal.UniformResourceStorageEditorInput;
import com.aptana.ui.util.UIUtils;
import java.net.URI;
import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IStorage;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.debug.core.model.ILineBreakpoint;
import org.eclipse.debug.internal.ui.sourcelookup.SourceLookupManager;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.ui.IEditorDescriptor;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.ide.FileStoreEditorInput;
import org.eclipse.ui.ide.IDE;
import org.eclipse.ui.part.FileEditorInput;
import org.eclipse.ui.texteditor.IDocumentProvider;
import org.eclipse.ui.texteditor.ITextEditor;

public final class SourceDisplayUtil {
    private SourceDisplayUtil() {
    }

    public static IEditorInput getEditorInput(Object element) {
        if (element instanceof IFile) {
            return new FileEditorInput((IFile)element);
        }
        if (element instanceof ILineBreakpoint) {
            IMarker marker = ((ILineBreakpoint)element).getMarker();
            if (marker instanceof IUniformResourceMarker) {
                IUniformResource resource = ((IUniformResourceMarker)marker).getUniformResource();
                element = resource.getAdapter(IStorage.class);
                if (element == null) {
                    element = resource;
                }
            } else {
                return new FileEditorInput((IFile)marker.getResource());
            }
        }
        if (element instanceof IFileStore) {
            IFileStore fileStore = (IFileStore)element;
            Object[] files = ResourcesPlugin.getWorkspace().getRoot().findFilesForLocationURI(fileStore.toURI());
            if (ArrayUtil.isEmpty((Object[])files)) {
                return new FileStoreEditorInput(fileStore);
            }
            return new FileEditorInput((IFile)files[0]);
        }
        if (element instanceof UniformResourceStorage) {
            if (((UniformResourceStorage)element).getFullPath() != null) {
                element.hashCode();
            }
            if (((UniformResourceStorage)element).exists()) {
                return new UniformResourceStorageEditorInput((UniformResourceStorage)element);
            }
            return null;
        }
        if (element instanceof IAdaptable) {
            return (IEditorInput)((IAdaptable)element).getAdapter(IEditorInput.class);
        }
        return null;
    }

    public static String getEditorId(IEditorInput input, Object element) {
        try {
            UniformResourceStorage storage;
            URI uri;
            String scheme;
            if (input instanceof UniformResourceStorageEditorInput && ("http".equals(scheme = (uri = (storage = (UniformResourceStorage)((UniformResourceStorageEditorInput)input).getStorage()).getURI()).getScheme()) || "https".equals(scheme))) {
                return IDE.getEditorDescriptor((String)(String.valueOf(input.getName()) + ".html")).getId();
            }
            IEditorDescriptor descriptor = IDE.getEditorDescriptor((String)input.getName());
            return descriptor.getId();
        }
        catch (PartInitException e) {
            return null;
        }
    }

    public static void openInEditor(IEditorInput input, int lineNumber) throws PartInitException {
        SourceDisplayUtil.openInEditor(UIUtils.getActivePage(), input, lineNumber);
    }

    public static void openInEditor(IWorkbenchPage page, IEditorInput input, int lineNumber) throws PartInitException {
        IEditorPart editorPart = IDE.openEditor((IWorkbenchPage)page, (IEditorInput)input, (String)SourceDisplayUtil.getEditorId(input, null));
        SourceDisplayUtil.revealLineInEditor(editorPart, lineNumber);
    }

    public static void revealLineInEditor(IEditorPart editorPart, int lineNumber) {
        IWorkbenchPage page;
        block10: {
            if (lineNumber > 0) {
                ITextEditor textEditor = null;
                textEditor = editorPart instanceof ITextEditor ? (ITextEditor)editorPart : (ITextEditor)editorPart.getAdapter(ITextEditor.class);
                if (textEditor != null) {
                    IDocumentProvider provider = textEditor.getDocumentProvider();
                    try {
                        provider.connect((Object)textEditor.getEditorInput());
                    }
                    catch (CoreException e) {
                        e.getCause();
                        return;
                    }
                    IDocument document = provider.getDocument((Object)textEditor.getEditorInput());
                    try {
                        try {
                            IRegion line = document.getLineInformation(lineNumber - 1);
                            textEditor.selectAndReveal(line.getOffset(), line.getLength());
                        }
                        catch (BadLocationException e) {
                            IdeLog.logWarning((Plugin)DebugUiPlugin.getDefault(), (Throwable)e);
                            provider.disconnect((Object)document);
                            break block10;
                        }
                    }
                    catch (Throwable throwable) {
                        provider.disconnect((Object)document);
                        throw throwable;
                    }
                    provider.disconnect((Object)document);
                }
            }
        }
        if (!(page = editorPart.getSite().getPage()).isPartVisible((IWorkbenchPart)editorPart)) {
            page.activate((IWorkbenchPart)editorPart);
        }
    }

    public static IEditorPart findEditor(IEditorInput input) {
        return UIUtils.getActivePage().findEditor(input);
    }

    public static void displaySource(Object context, boolean forceSourceLookup) {
        SourceDisplayUtil.displaySource(context, UIUtils.getActivePage(), forceSourceLookup);
    }

    public static void displaySource(Object context, IWorkbenchPage page, boolean forceSourceLookup) {
        SourceLookupManager.getDefault().displaySource(context, page, forceSourceLookup);
    }
}

